<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Users extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'email', 'country_code', 'phone', 'lang', 'is_notify', 'is_approved', 'is_blocked', 'password');
    protected $hidden = array('password');

    public function healtFileProfile()
    {
        return $this->hasMany('App\Models\HealthFileProfile');
    }

    public function exams()
    {
        return $this->belongsToMany('App\Models\Exam');
    }

    public function wallets()
    {
        return $this->hasMany('App\Models\Wallet');
    }

    public function orders()
    {
        return $this->hasMany('App\Models\Order');
    }

}